/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.patch;

import info.msxlaunchers.openmsx.common.FileTypeUtils;
import info.msxlaunchers.openmsx.launcher.patch.PatchException;
import info.msxlaunchers.openmsx.launcher.patch.PatchExceptionIssue;
import info.msxlaunchers.openmsx.launcher.patch.Patcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

abstract class AbstractPatcher
implements Patcher {
    private final String TEMP_FILENAME = "tempFile.tmp";

    AbstractPatcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void patch(Path fileToPatch, Path patchFile, Path targetFile, boolean skipChecksumValidation, String checksum) throws PatchException {
        Objects.requireNonNull(fileToPatch);
        Objects.requireNonNull(patchFile);
        Path realFileToPatch = null;
        try {
            realFileToPatch = this.unzipFileToPatchIfNeeded(fileToPatch, targetFile == null);
            this.performValidation(realFileToPatch, patchFile, skipChecksumValidation, checksum);
            this.patchFileData(realFileToPatch, patchFile, targetFile, skipChecksumValidation);
            this.cleanupTemporaryFile(fileToPatch, realFileToPatch);
        }
        catch (Throwable throwable) {
            this.cleanupTemporaryFile(fileToPatch, realFileToPatch);
            throw throwable;
        }
    }

    protected abstract void performValidation(Path var1, Path var2, boolean var3, String var4) throws PatchException;

    abstract void patchFileData(Path var1, Path var2, Path var3, boolean var4) throws PatchException;

    protected void validateFileSize(Path file, int minLimit, int maxLimit, PatchExceptionIssue exceptionIssue) throws PatchException {
        try {
            long size = Files.size(file);
            if (size < (long)minLimit || size > (long)maxLimit) {
                throw new PatchException(exceptionIssue);
            }
        }
        catch (IOException ioe) {
            throw new PatchException(PatchExceptionIssue.IO);
        }
    }

    protected boolean isByteSequenceEqualToString(byte[] data, int start, byte[] stringSequence) {
        return Arrays.equals(Arrays.copyOfRange(data, start, start + stringSequence.length), stringSequence);
    }

    private Path unzipFileToPatchIfNeeded(Path fileToPatch, boolean patchSourceDirectly) throws PatchException {
        if (FileTypeUtils.isZIP(fileToPatch.toFile())) {
            if (patchSourceDirectly) {
                throw new PatchException(PatchExceptionIssue.ZIP_SOURCE_FILE_CANNOT_BE_PATCHED_DIRECTLY);
            }
            try {
                Path tempFile = Files.createTempFile("tempFile.tmp", null, new FileAttribute[0]);
                try (ZipFile zip = new ZipFile(fileToPatch.toFile());){
                    ZipEntry firstZipEntry = zip.entries().nextElement();
                    try (InputStream inputStream = zip.getInputStream(firstZipEntry);){
                        Files.copy(inputStream, tempFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                }
                catch (IOException e) {
                    throw new PatchException(PatchExceptionIssue.IO);
                }
                return tempFile;
            }
            catch (IOException ioe) {
                throw new PatchException(PatchExceptionIssue.IO);
            }
        }
        return fileToPatch;
    }

    private void cleanupTemporaryFile(Path file, Path temporaryUnzippedFile) {
        if (FileTypeUtils.isZIP(file.toFile()) && temporaryUnzippedFile != null) {
            try {
                Files.deleteIfExists(temporaryUnzippedFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

